/*
 * Decompiled with CFR 0.152.
 */
package com.android.print.sdk.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.android.print.sdk.IPrinterPort;
import com.android.print.sdk.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public class BluetoothPort
implements IPrinterPort {
    private static final String TAG = "BluetoothPort";
    private BluetoothDevice mDevice;
    private BluetoothSocket mSocket;
    private BluetoothAdapter mAdapter;
    private ConnectThread mConnectThread;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Context mContext;
    private Handler mHandler;
    private int mState;
    private int readLen;
    private final UUID PRINTER_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
    private BroadcastReceiver boundDeviceReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (!BluetoothPort.this.mDevice.equals((Object)device)) {
                    return;
                }
                switch (device.getBondState()) {
                    case 11: {
                        Utils.Log(BluetoothPort.TAG, "bounding......");
                        break;
                    }
                    case 12: {
                        Utils.Log(BluetoothPort.TAG, "bound success");
                        BluetoothPort.this.mContext.unregisterReceiver(BluetoothPort.this.boundDeviceReceiver);
                        BluetoothPort.this.PairOrConnect(false);
                        break;
                    }
                    case 10: {
                        BluetoothPort.this.mContext.unregisterReceiver(BluetoothPort.this.boundDeviceReceiver);
                        BluetoothPort.this.setState(102);
                        Utils.Log(BluetoothPort.TAG, "bound cancel");
                        break;
                    }
                }
            }
        }
    };

    public BluetoothPort(BluetoothDevice device, Handler handler) {
        this.mHandler = handler;
        this.mDevice = device;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mState = 103;
    }

    public BluetoothPort(String address, Handler handler) {
        this.mHandler = handler;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mDevice = this.mAdapter.getRemoteDevice(address);
        this.mState = 103;
    }

    @Override
    public void open() {
        Utils.Log(TAG, "connect to: " + this.mDevice.getName());
        if (this.mState != 103) {
            this.close();
        }
        if (this.mDevice.getBondState() == 10) {
            Log.i((String)TAG, (String)"device.getBondState() is BluetoothDevice.BOND_NONE");
            this.PairOrConnect(true);
        } else if (this.mDevice.getBondState() == 12) {
            this.PairOrConnect(false);
        }
    }

    private void PairOrConnect(boolean pair) {
        if (pair) {
            IntentFilter boundFilter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
            this.mContext.registerReceiver(this.boundDeviceReceiver, boundFilter);
            boolean success = false;
            try {
                Method createBondMethod = BluetoothPort.class.getMethod("createBond", new Class[0]);
                success = (Boolean)createBondMethod.invoke((Object)this.mDevice, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            Log.i((String)TAG, (String)("createBond is success? : " + success));
        } else {
            this.mConnectThread = new ConnectThread();
            this.mConnectThread.start();
        }
    }

    @TargetApi(value=10)
    private boolean ReTryConnect() {
        Utils.Log(TAG, "android SDK version is:" + Build.VERSION.SDK_INT);
        try {
            if (Build.VERSION.SDK_INT >= 10) {
                this.mSocket = this.mDevice.createInsecureRfcommSocketToServiceRecord(this.PRINTER_UUID);
            } else {
                Method method = this.mDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.mSocket = (BluetoothSocket)method.invoke((Object)this.mDevice, 1);
            }
            this.mSocket.connect();
        }
        catch (Exception e) {
            Utils.Log(TAG, "connect failed:");
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        Utils.Log(TAG, "close()");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "close socket failed");
            e.printStackTrace();
        }
        this.mConnectThread = null;
        this.mDevice = null;
        this.mSocket = null;
        if (this.mState != 102) {
            this.setState(103);
        }
    }

    @Override
    public int write(byte[] data) {
        block3: {
            try {
                if (this.outputStream != null) {
                    this.outputStream.write(data);
                    this.outputStream.flush();
                    break block3;
                }
                return -1;
            }
            catch (IOException e) {
                Utils.Log(TAG, "write error.");
                e.printStackTrace();
                return -1;
            }
        }
        return 0;
    }

    @Override
    public byte[] read() {
        byte[] readBuff = null;
        try {
            if (this.inputStream != null && (this.readLen = this.inputStream.available()) > 0) {
                readBuff = new byte[this.readLen];
                this.inputStream.read(readBuff);
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "read error");
            e.printStackTrace();
        }
        Log.w((String)TAG, (String)("read length:" + this.readLen));
        return readBuff;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] read(int timeout) {
        byte[] receiveBytes = null;
        try {
            while (true) {
                if ((this.readLen = this.inputStream.available()) > 0 || (timeout -= 50) <= 0) {
                    if (this.readLen <= 0) return receiveBytes;
                    receiveBytes = new byte[this.readLen];
                    this.inputStream.read(receiveBytes);
                    return receiveBytes;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "read error1");
            e.printStackTrace();
        }
        return receiveBytes;
    }

    private synchronized void setState(int state) {
        Utils.Log(TAG, "setState() " + this.mState + " -> " + state);
        if (this.mState != state) {
            this.mState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mState).sendToTarget();
            }
        }
    }

    @Override
    public int getState() {
        return this.mState;
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = false;
            BluetoothPort.this.mAdapter.cancelDiscovery();
            try {
                BluetoothPort.this.mSocket = BluetoothPort.this.mDevice.createRfcommSocketToServiceRecord(BluetoothPort.this.PRINTER_UUID);
                BluetoothPort.this.mSocket.connect();
            }
            catch (IOException e) {
                Utils.Log(BluetoothPort.TAG, "ConnectThread failed. retry.");
                e.printStackTrace();
                hasError = BluetoothPort.this.ReTryConnect();
            }
            ConnectThread e = this;
            synchronized (e) {
                BluetoothPort.this.mConnectThread = null;
            }
            if (!hasError) {
                try {
                    BluetoothPort.this.inputStream = BluetoothPort.this.mSocket.getInputStream();
                    BluetoothPort.this.outputStream = BluetoothPort.this.mSocket.getOutputStream();
                }
                catch (IOException e2) {
                    hasError = true;
                    Utils.Log(BluetoothPort.TAG, "Get Stream failed");
                    e2.printStackTrace();
                }
            }
            if (hasError) {
                BluetoothPort.this.setState(102);
                BluetoothPort.this.close();
            } else {
                BluetoothPort.this.setState(101);
            }
        }
    }
}

